"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "io", {
    enumerable: true,
    get: function() {
        return io;
    }
});
const _workasyncstorageexternal = require("../app-render/work-async-storage.external");
const _workunitasyncstorageexternal = require("../app-render/work-unit-async-storage.external");
const _dynamicrendering = require("../app-render/dynamic-rendering");
const _invarianterror = require("../../shared/lib/invariant-error");
function io(expression, type) {
    const workUnitStore = _workunitasyncstorageexternal.workUnitAsyncStorage.getStore();
    if (workUnitStore) {
        if (workUnitStore.type === 'prerender') {
            const workStore = _workasyncstorageexternal.workAsyncStorage.getStore();
            if (workStore) {
                let message;
                switch(type){
                    case 'time':
                        message = `Route "${workStore.route}" used ${expression} instead of using \`performance\` or without explicitly calling \`await connection()\` beforehand. See more info here: https://nextjs.org/docs/messages/next-prerender-current-time`;
                        break;
                    case 'random':
                        message = `Route "${workStore.route}" used ${expression} outside of \`"use cache"\` and without explicitly calling \`await connection()\` beforehand. See more info here: https://nextjs.org/docs/messages/next-prerender-random`;
                        break;
                    case 'crypto':
                        message = `Route "${workStore.route}" used ${expression} outside of \`"use cache"\` and without explicitly calling \`await connection()\` beforehand. See more info here: https://nextjs.org/docs/messages/next-prerender-crypto`;
                        break;
                    default:
                        throw new _invarianterror.InvariantError('Unknown expression type in abortOnSynchronousPlatformIOAccess.');
                }
                const errorWithStack = new Error(message);
                (0, _dynamicrendering.abortOnSynchronousPlatformIOAccess)(workStore.route, expression, errorWithStack, workUnitStore);
            }
        } else if (workUnitStore.type === 'request' && workUnitStore.prerenderPhase === true) {
            const requestStore = workUnitStore;
            (0, _dynamicrendering.trackSynchronousPlatformIOAccessInDev)(requestStore);
        }
    }
}

//# sourceMappingURL=utils.js.map